/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.PathUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutableUtil {
    private static final String PATHEXT = "PATHEXT";
    private static final String WHICH_PATH = "/usr/bin/which";
    private static final String PATH = "PATH";

    private ExecutableUtil() {
    }

    public static IPath find(String executableName, boolean appendExtension, List<IPath> searchLocations) {
        return ExecutableUtil.find(executableName, appendExtension, searchLocations, null);
    }

    public static IPath find(String executableName, boolean appendExtension, List<IPath> searchLocations, IPath workingDirectory) {
        return ExecutableUtil.find(executableName, appendExtension, searchLocations, null, workingDirectory);
    }

    public static IPath find(String executableName, boolean appendExtension, List<IPath> searchLocations, FileFilter filter) {
        return ExecutableUtil.find(executableName, appendExtension, searchLocations, filter, null);
    }

    public static IPath find(String executableName, boolean appendExtension, List<IPath> searchLocations, FileFilter filter, IPath workingDirectory) {
        if (executableName == null) {
            return null;
        }
        Map<String, String> env = ShellExecutable.getEnvironment(workingDirectory);
        String pathENV = env != null && env.containsKey(PATH) ? PathUtil.convertPATH(env.get(PATH)) : System.getenv(PATH);
        boolean infoLoggingEnabled = IdeLog.isInfoEnabled(CorePlugin.getDefault(), "com.aptana.core/debug/shell");
        String[] paths = pathENV.split(File.pathSeparator);
        if (infoLoggingEnabled) {
            IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Searching for {0} in PATH locations: {1}", executableName, StringUtil.join(", ", paths)), "com.aptana.core/debug/shell");
        }
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String pathString = stringArray[n2];
            IPath path = Path.fromOSString((String)pathString).append(executableName);
            IPath result = ExecutableUtil.findExecutable(path, appendExtension);
            if (result != null && (filter == null || filter.accept(result.toFile()))) {
                if (infoLoggingEnabled) {
                    IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Found executable on PATH: {0}", result), "com.aptana.core/debug/shell");
                }
                return result;
            }
            ++n2;
        }
        return ExecutableUtil.findInLocations(executableName, appendExtension, searchLocations, filter);
    }

    public static IPath findInLocations(String executableName, boolean appendExtension, List<IPath> searchLocations, FileFilter filter) {
        boolean infoLoggingEnabled = IdeLog.isInfoEnabled(CorePlugin.getDefault(), "com.aptana.core/debug/shell");
        if (searchLocations != null) {
            for (IPath location : searchLocations) {
                IPath result = ExecutableUtil.findExecutable(location.append(executableName), appendExtension);
                if (result == null || filter != null && !filter.accept(result.toFile())) continue;
                if (infoLoggingEnabled) {
                    IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Found executable at common location: {0}", result), "com.aptana.core/debug/shell");
                }
                return result;
            }
        }
        return null;
    }

    private static IPath findExecutable(IPath basename, boolean appendExtension) {
        if ("win32".equals(Platform.getOS()) && appendExtension) {
            String[] extensions;
            String[] stringArray = extensions = System.getenv(PATHEXT).split(File.pathSeparator);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IPath pathWithExt;
                String ext = stringArray[n2];
                if (ext.length() > 0 && ext.charAt(0) == '.') {
                    ext = ext.substring(1);
                }
                if (ExecutableUtil.isExecutable(pathWithExt = basename.addFileExtension(ext))) {
                    return pathWithExt;
                }
                ++n2;
            }
        } else if (ExecutableUtil.isExecutable(basename)) {
            return basename;
        }
        return null;
    }

    public static boolean isExecutable(IPath path) {
        if (path == null) {
            return false;
        }
        File file = path.toFile();
        if (file == null || !file.exists() || file.isDirectory()) {
            return false;
        }
        try {
            Method m = File.class.getMethod("canExecute", new Class[0]);
            if (m != null) {
                return (Boolean)m.invoke((Object)file, new Object[0]);
            }
        }
        catch (Exception m) {
            // empty catch block
        }
        if ("win32".equals(Platform.getOS())) {
            return true;
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
        return fileStore.fetchInfo().getAttribute(4);
    }

    public static boolean isGemInstallable() {
        if (!"win32".equals(Platform.getOS())) {
            IPath gemBin = ExecutableUtil.find("gem", true, null);
            String output = ProcessUtil.outputForCommand(gemBin.toOSString(), null, "environment");
            String searchString = "EXECUTABLE DIRECTORY:";
            int index = output.indexOf("EXECUTABLE DIRECTORY:");
            output = output.substring(index + "EXECUTABLE DIRECTORY:".length());
            output = output.split("\r\n|\r|\n")[0].trim();
            return new File(output).canWrite();
        }
        return true;
    }
}

